/***************************************************************************
 *
 * Copyright 2010,2011 BMW Car IT GmbH
 * Copyright (C) 2012 DENSO CORPORATION and Robert Bosch Car Multimedia Gmbh
 *
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ****************************************************************************/
#include "SetDisplayCSCCommand.h"
#include "ICommandExecutor.h"
#include "Scene.h"
#include "Log.h"

SetDisplayCSCCommand::~SetDisplayCSCCommand()
{
}

ExecutionResult SetDisplayCSCCommand::execute(ICommandExecutor* executor)
{
    Scene& scene = *(executor->getScene());
    ExecutionResult result = ExecutionFailed;
    //check if screen exist
    if (!scene.getScreen(m_screenID))
        return ExecutionFailed;

    LOG_INFO("SetDisplayCSCCommand","on screen=" << m_screenID <<
                                        " set_to_default: "<< m_clrprop->set_to_default <<
                                        " hue: "<< m_clrprop->hue <<
                                        " saturation:"<< m_clrprop->saturation <<
                                        " brightness:"<< m_clrprop->brightness <<
                                        " contrast:"<< m_clrprop->contrast <<
                                        " hue_off:"<< m_clrprop->hue_off <<
                                        " saturation_off:"<< m_clrprop->saturation_off <<
                                        " brightness_off:"<< m_clrprop->brightness_off <<
                                        " type:"<< m_clrprop->type);

    IRenderer* renderer = *((executor->getRendererList())->begin());
    if (renderer)
    {
	ilmScreenState state = ILM_SCREEN_ON;
        renderer->setCSC(m_screenID, m_clrprop);
        result = ExecutionSuccess;
    }
    else
        return ExecutionFailed;

    return result;
}

const std::string SetDisplayCSCCommand::getString()
{
    std::stringstream description;
    description << "SetDisplayCSCCommand("
                << "m_screenID=" << m_screenID << ")" ;

    return description.str();
}
